#ifndef _WAV_H
#define _WAV_H

#include <string>
#include "types.h"

#pragma pack(push,1)
/* specific waveform format structure for PCM data */
struct wavChunkFormat {
	u16		wFormatTag;        /* format type */
	u16		nChannels;         /* number of channels (i.e. mono, stereo...) */
	u32		nSamplesPerSec;    /* sample rate */
	u32		nAvgBytesPerSec;   /* for buffer estimation */
	u16		nBlockAlign;       /* block size of data */
	u16     wBitsPerSample;
};
#pragma pack(pop)

bool saveFile8Bit( const std::string& outFile, const u8* data, int size, int sampleFrequency );

#endif
